INCLUDE "GLOBALS"

DIM lastmoveconsumed AS INTEGER
lastmoveconsumed = -1

DIM linecount AS INTEGER
linecount = 0

DIM linetoread AS INTEGER
linetoread = 0

DIM thismovetype AS INTEGER

DIM movex, movey, movez, moveiv AS FLOAT
DIM end1, end2, center1, center2, direction, axistype AS FLOAT
DIM consumed, readupto AS INTEGER

DIM needsrevrecalibration AS BOOLEAN
needsrevrecalibration = FALSE

REPEAT
    WA(10)

    FORCE_SPEED = SPEED
    ENDMOVE_SPEED = SPEED

    consumed = TABLE(table_consumed)
    readupto = TABLE(table_readupto)
    lastmoveconsumed = -1

    WHILE readupto > consumed
        linetoread = consumed*10 + table_firstmove
        consumed = consumed + 1
        thismovetype = TABLE(linetoread)
        IF thismovetype = 0 OR thismovetype = 1 OR thismovetype = 5 OR thismovetype = 6 THEN
            movex = TABLE(linetoread+1)
            movey = TABLE(linetoread+2)
            movez = TABLE(linetoread+3)
            moveiv = TABLE(linetoread+4)
        ELSE
            end1 = TABLE(linetoread+1)
            end2 = TABLE(linetoread+2)
            center1 = TABLE(linetoread+3)
            center2 = TABLE(linetoread+4)
            direction = TABLE(linetoread+5)
            axistype = TABLE(linetoread+6)
        ENDIF

        IF lastmoveconsumed <> thismovetype THEN
            SELECT_CASE(thismovetype)
                'mill linear
                CASE 0 :
                    BASE(0,1,2,3)
                    'mill rapid
                CASE 1 :
                    BASE(0,1,2,3)
                CASE 2 :
                    BASE(0,1)
                CASE 3 :
                    BASE(1,2)
                CASE 4 :
                    BASE(0,2)
                CASE 5 :
                    'lathe linear
                    BASE(0,1)
                CASE 6 :
                    'lathe rapid
                    BASE(0,1)

            END_CASE
            lastmoveconsumed = thismovetype
        ENDIF

        SELECT_CASE(thismovetype)
            CASE 0 :
                MOVEABSSP(movex, movey, movez, moveiv)
            CASE 1 :
                MOVEABSSP(movex, movey, movez, moveiv)
                WAIT IDLE
            CASE 2,3,4 :
                TRIGGER
                ' MOVECIRCSP(end1,end2,center1,center2,direction)
                MHELICALSP(end1,end2,center1,center2,direction,0)
            CASE 5 :
                'Before doing a linear, set the correct speed if it varies in per rev mode
                IF needsrevrecalibration AND (TABLE(comms_perminperrev)> 0) AND (TABLE(table_eventhoming)=0) THEN
                    WA(500)
                    'adjustfeedforperrev()
                    'setfeedspeed()
                    needsrevrecalibration = FALSE
                ENDIF
                MOVEABSSP(movex, movey)
            CASE 6 :
                'WAIT IDLE
                ' wasconstsurfacespeed = TABLE(comms_perminperrev)
                TABLE(comms_perminperrev,0)
                rapidspeed = TABLE(comms_rapidspeed)
                'TABLE(comms_feed,rapidspeed)
                'setfeedspeed()
                'PRINT "Making a rapid. The speed is ",SPEED
                'BASE(0,1)
                SPEED = rapidspeed
                FORCE_SPEED = rapidspeed
                ENDMOVE_SPEED = rapidspeed
                MOVEABSSP(movex, movey)
                needsrevrecalibration = TRUE
                TABLE(comms_perminperrev,wasconstsurfacespeed)
                'WAIT IDLE

        END_CASE

        TABLE(table_idle, 0)
        IF TABLE(table_consumed) = 0 AND TABLE(table_readupto) = 0 THEN
            'Stop was pressed while this consumer was reading. So quit the loop
            EXIT_LOOP
        ELSE
            lastmoveconsumed = thismovetype
            movesmade = TABLE(table_movesmade) + 1
            TABLE(table_movesmade, movesmade)
        ENDIF

    WEND
    TABLE(table_consumed,readupto)

UNTIL FALSE
